/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.tsd;

import com.ibm.hwmca.base.tsd.TsdEnableControl;
import com.ibm.hwmca.base.tsd.TsdErrorIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;

public class TransSrvDataBean
extends PanelBean
implements TsdErrorIds {
    private static final String TRACE_MASKT = "XTSD   T";
    private static final String TRACE_MASKF = "XTSD   F";
    private static final String TRACE_MASKD = "XTSD   D";
    private static final String TSD_TASK_TITLE = "tsd.task.title";
    public HashMap enableControl = new HashMap();
    public static final String ACTION = "action";
    public static final String COMMIT = "commit";
    public static final String BEAN = "bean";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "TsdBean");
    private transient TransSrvDataBean bean;
    private transient boolean changed;
    private boolean rsfEnabled = false;
    private TsdEnableControl enabObject;
    private String[] m_sSrvDataSelGBSelection;
    private String[] m_sSrvDataDestChoiceSelection;
    private String m_sPMHNumberEdit;
    private String m_sProdEngFilesEdit;
    private String[] names;
    private boolean pefiles = false;

    public String[] getSrvDataSelGBSelection() {
        return this.m_sSrvDataSelGBSelection;
    }

    public void setSrvDataSelGBSelection(String[] selected) throws IllegalUserDataException {
        int size = selected.length;
        Trace.trace(TRACE_MASKF, "Set GB selection length = " + size);
        this.m_sSrvDataSelGBSelection = selected;
        this.userTaskManager.setEnabled("IBMServiceItem", this.rsfEnabled);
        this.userTaskManager.setEnabled("DisketteItem", true);
        this.userTaskManager.setEnabled("DVDCartridgeItem", true);
        int ix = 0;
        while (ix < size) {
            this.enabObject = (TsdEnableControl)this.enableControl.get(selected[ix]);
            if (!this.enabObject.isRetainFlag()) {
                this.userTaskManager.setEnabled("IBMServiceItem", false);
            }
            if (!this.enabObject.isDisketteFlag()) {
                this.userTaskManager.setEnabled("DisketteItem", false);
            }
            if (!this.enabObject.isDvdFlag()) {
                this.userTaskManager.setEnabled("DVDCartridgeItem", false);
            }
            ++ix;
        }
    }

    public String[] getSrvDataDestChoiceSelection() {
        return this.m_sSrvDataDestChoiceSelection;
    }

    public void setSrvDataDestChoiceSelection(String[] selected) throws IllegalUserDataException {
        this.m_sSrvDataDestChoiceSelection = selected;
    }

    public String getProdEngFilesEdit() {
        return this.m_sProdEngFilesEdit;
    }

    public void setProdEngFilesEdit(String s) throws IllegalUserDataException {
        this.m_sProdEngFilesEdit = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public String getPMHNumberEdit() {
        return this.m_sPMHNumberEdit;
    }

    public void setPMHNumberEdit(String s) throws IllegalUserDataException {
        this.m_sPMHNumberEdit = s;
    }

    public void load() {
        this.m_sPMHNumberEdit = "";
        this.m_sSrvDataSelGBSelection = new String[0];
        this.setSrvDataDestChoiceSelection(new String[]{"IBMServiceItem"});
        this.m_sProdEngFilesEdit = "";
    }

    public void prepare() {
        String elementName;
        Trace.trace(TRACE_MASKT, "--> prepare");
        int i = 0;
        while (i < this.names.length) {
            String elementName2 = "SrvDataSel" + i + "Toggle";
            this.userTaskManager.setCaptionText(elementName2, this.names[i]);
            Trace.trace(TRACE_MASKF, "Get elementName = " + elementName2);
            this.enabObject = (TsdEnableControl)this.enableControl.get(elementName2);
            this.userTaskManager.setEnabled(elementName2, this.enabObject.isDataSelectFlag());
            ++i;
        }
        this.userTaskManager.setEnabled("IBMServiceItem", this.rsfEnabled);
        int i2 = this.names.length;
        while (i2 < 30) {
            elementName = "SrvDataSel" + i2 + "Toggle";
            this.userTaskManager.setShown(elementName, false);
            ++i2;
        }
        elementName = "ProdEngFilesEdit";
        this.userTaskManager.setShown(elementName, this.pefiles);
        Trace.trace(TRACE_MASKT, "<-- prepare");
    }

    public void setNames(String[] names) {
        this.names = names;
    }

    public void enablePeFiles(boolean pefiles) {
        this.pefiles = pefiles;
    }

    public void setRsfEnabled(boolean rsfEnabled) {
        this.rsfEnabled = rsfEnabled;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "--> panelAction(" + event + ")");
        try {
            String element = event.getElementName();
            Trace.trace(TRACE_MASKT, "element = " + element);
            if (element.equals("SendButton")) {
                String[] destRadio;
                LocalizableText ans;
                BaseMessageText msg;
                LocalizableText title;
                this.userTaskManager.storeAllElements();
                boolean goForIt = true;
                String[] selData = this.getSrvDataSelGBSelection();
                String peFileEdit = this.getProdEngFilesEdit();
                Trace.trace(TRACE_MASKD, "selData.length = " + selData.length);
                Trace.trace(TRACE_MASKD, "peFileEdit length = " + peFileEdit.length());
                Trace.trace(TRACE_MASKD, "peFileEdit = " + peFileEdit);
                if (selData.length == 0 && peFileEdit.length() == 0) {
                    Trace.trace(TRACE_MASKD, "NO DATA SELECTED");
                    title = new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE);
                    msg = new BaseMessageText("TSDUSER1");
                    ans = CommonMsgApp.showMessageBox(this.userTaskManager, title, msg);
                    goForIt = false;
                }
                if (!(this.userTaskManager.isEnabled("IBMServiceItem") || this.userTaskManager.isEnabled("DisketteItem") || this.userTaskManager.isEnabled("DVDCartridgeItem"))) {
                    Trace.trace(TRACE_MASKD, "NO DESTINATION AVAILABLE");
                    title = new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE);
                    msg = new BaseMessageText("TSDUSER2");
                    ans = CommonMsgApp.showMessageBox(this.userTaskManager, title, msg);
                    goForIt = false;
                }
                if (!this.userTaskManager.isEnabled((destRadio = this.getSrvDataDestChoiceSelection())[0])) {
                    Trace.trace(TRACE_MASKD, "DESTINATION DISABLED");
                    LocalizableText title2 = new LocalizableText(BaseTextBundle.getBundleName(), TSD_TASK_TITLE);
                    BaseMessageText msg2 = new BaseMessageText("TSDUSER3");
                    LocalizableText ans2 = CommonMsgApp.showMessageBox(this.userTaskManager, title2, msg2);
                    goForIt = false;
                }
                if (goForIt) {
                    PanelTaskletRequest request = new PanelTaskletRequest();
                    request.setData(ACTION, COMMIT);
                    request.setData(BEAN, this);
                    this.postTaskletRequest(request);
                }
            } else if (element.equals("ResetButton")) {
                this.setPMHNumberEdit("");
                this.setSrvDataSelGBSelection(new String[0]);
                this.setProdEngFilesEdit("");
                this.userTaskManager.refreshAllElements();
            } else if (element.equals("CancelButton")) {
                boolean ans;
                this.userTaskManager.storeAllElements();
                this.postParentalAction(event, this);
                if (this.changed && !(ans = CommonMsgApp.showDataChangedConfirmation(this.userTaskManager))) {
                    Trace.trace(TRACE_MASKF, "throw IllegalUserDataException <-- panelAction()");
                    throw new IllegalUserDataException();
                }
                this.dispose();
            }
        }
        catch (IllegalUserDataException e) {
            throw e;
        }
        catch (Exception e) {
            new FrameworkLog(logInfo, 20577, e).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<-- panelAction()");
    }
}

